#include <napi.h>
#include <stdio.h>
#include <iostream>
#include "node_thumbnailcache.hpp"
#include "node_helpers.hpp"
#include "photochemistry/image.hpp"
#include "photochemistry/process.hpp"
#include "photochemistry/utf8.hpp"
#include <opencv2/opencv.hpp>
#include <future>
#include <iostream>
#include <memory>


using namespace photochemistry;

PCHThumbnailCache::PCHThumbnailCache(const Napi::CallbackInfo& info) :
  Napi::ObjectWrap<PCHThumbnailCache>(info) {
    Napi::Env env = info.Env();
    int length = info.Length();
    if (length <= 0 || !info[0].IsString()) {
        Napi::TypeError::New(env, "String argument for path expected").ThrowAsJavaScriptException();
        return;
    }
    std::string path = info[0].As<Napi::String>().Utf8Value();
    cache = std::make_shared<photochemistry::storage::ThumbnailCache>(path);
}

void PCHThumbnailCache::setRootPath(const Napi::CallbackInfo& info) {
  cache->setRootPath(info[0].As<Napi::String>().Utf8Value());
}

void PCHThumbnailCache::getThumbnail(const Napi::CallbackInfo& info) {
    Napi::Env env = info.Env();

    Napi::Function jsCallback = info[2].As<Napi::Function>();
    Context* context = new Context(Napi::Persistent(info.This()));
    auto threadSafeFunction = Napi::TypedThreadSafeFunction<Context, std::vector<uint8_t>, callbackWithBytes>::New(
        env, jsCallback, "callback", 0, 1, context, defaultFinalizer);
    Ref();

    cache->getThumbnailData(info[0].As<Napi::String>().Utf8Value(), info[1].As<Napi::Number>().Int32Value(),
        [threadSafeFunction, this](std::vector<uint8_t> data) mutable {
            std::vector<uint8_t>* dataCopy = new std::vector<uint8_t>(data);
            // threadSafeFunction.Acquire();
            threadSafeFunction.NonBlockingCall(dataCopy);
            threadSafeFunction.Release();
            Unref();
        });
    return;
}

Napi::Object PCHThumbnailCache::Init(Napi::Env env, Napi::Object exports) {
  Napi::Function ThumbnailCacheConstructor =
    DefineClass(env, "ThumbnailCacheConstructor", {
        InstanceMethod("setRootPath", &PCHThumbnailCache::setRootPath),
        InstanceMethod("getThumbnail", &PCHThumbnailCache::getThumbnail),
    });
  Napi::FunctionReference* ThumbnailCacheConstructorRef = new Napi::FunctionReference();
  *ThumbnailCacheConstructorRef = Napi::Persistent(ThumbnailCacheConstructor);
  exports.Set("ThumbnailCache", ThumbnailCacheConstructor);
  return exports;
}