#include <napi.h>
#include <stdio.h>
#include <iostream>
#include "node_falloff.hpp"
#include "node_helpers.hpp"
#include "photochemistry/image.hpp"
#include "photochemistry/imageloader.hpp"
#include <opencv2/opencv.hpp>

#include <future>
#include <iostream>
#include <memory>

using namespace photochemistry;

PCHFalloffProfile::PCHFalloffProfile(const Napi::CallbackInfo& info) :
  Napi::ObjectWrap<PCHFalloffProfile>(info) {
    Napi::Env env = info.Env();
    int length = info.Length();
    if (length <= 0 || !info[0].IsString()) {
        Napi::TypeError::New(env, "String argument for path expected").ThrowAsJavaScriptException();
        return;
    }
    std::string path = info[0].As<Napi::String>().Utf8Value();
    Image image;
    if (ImageLoader::loadImageFromPath(path, image, true)) {
        falloff = photochemistry::profiles::Falloff::fromImage(image);
        std::cout << "Successfully loaded falloff profile image from " << path << std::endl;
    } else {
        std::cout << "Warning: couldn't load falloff profile image from " << path << std::endl;
    }
}

Napi::Value PCHFalloffProfile::getJPEG(const Napi::CallbackInfo& info) {
    cv::Mat mat8;
    falloff.brightnessMap.convertTo(mat8, CV_8U, 255.0);
    std::vector<uint8_t> buf;
    cv::imencode(".jpg", mat8, buf);
    return U8ArrayView(info.Env(), buf.data(), buf.size());
}

Napi::Value PCHFalloffProfile::getJSON(const Napi::CallbackInfo& info) {
    return Napi::String::New(info.Env(), falloff.toJSON().dump());
}

Napi::Object PCHFalloffProfile::Init(Napi::Env env, Napi::Object exports) {
  Napi::Function Constructor =
    DefineClass(env, "FalloffProfileConstructor", {
        InstanceMethod("getJPEG", &PCHFalloffProfile::getJPEG),
        InstanceMethod("getJSON", &PCHFalloffProfile::getJSON),
    });
  Napi::FunctionReference* ConstructorRef = new Napi::FunctionReference();
  *ConstructorRef = Napi::Persistent(Constructor);
  exports.Set("FalloffProfile", Constructor);
  return exports;
}


